//	GenStructs.c

#include "GenStructs.h"
#include "FileSystemTypes.h"

Gen_SectorSpec		Gen_gLastValidSector	= { Gen_kTracksPerDisk,		Gen_kSectorsPerTrack };
Gen_SectorSpec		Gen_gLastValidSector400	= { Gen_kTracksPerDisk400,	Gen_kSectorsPerTrack400 };

//	accessing a sector
Gen_Sector	*Gen_GetSector(DiskImageRec *imageRecP, Gen_SectorSpec sectorSpec)
{
	Gen_Sector	*sectorP = NULL;
	
	if (
		sectorSpec.track < Gen_kTracksPerDisk
		&& sectorSpec.sector < Gen_kSectorsPerTrack
	) {
		sectorP = &(imageRecP->image.gen->track[(sectorSpec).track].sector[(sectorSpec).sector]);
	} else {
		ReportError(IC_Err_READ_ILLEGAL_TRACK_SECTOR);
	}
	
	return sectorP;
}
